/*
 * Decompiled with CFR 0.152.
 */
package common.ui;

import common.misc.GlobalParameters;
import common.ui.Button;
import common.ui.CalculatorCanvas;
import common.ui.DisplaySizes;
import common.ui.EditPanel;
import common.ui.UiComponent;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public abstract class ButtonPanel
extends UiComponent {
    protected static final int NUMBER_OF_COLUMNS = 4;
    protected static final int NUMBER_OF_COLUMNS_PORTRAIT = 5;
    protected CalculatorCanvas calculatorCanvas = null;
    protected EditPanel editPanel = null;
    protected Vector buttons = new Vector();
    protected Button highlightedButton = null;
    protected int highlightedButtonIndex = 0;
    protected int spacing = 0;
    protected int numberOfRows = 0;
    protected int currentRowIndex = 0;
    protected int previousRowIndex = 0;
    protected int currentColumnIndex = 0;
    protected int columns = 4;
    protected int width;

    public ButtonPanel(DisplaySizes displaySize) {
        super(displaySize);
        this.width = displaySize.getWidth();
        if (this.width == 240) {
            this.columns = 4;
        } else if (this.width == 320) {
            this.columns = 5;
        } else if (this.width == 502 || this.width == 360 || this.width == 298 || this.width == 251) {
            this.columns = 5;
        }
    }

    public void repaint() {
        if (this.calculatorCanvas != null) {
            this.calculatorCanvas.repaint();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == GlobalParameters.COMMAND_SELECT) {
            this.highlightedButton.press();
        }
    }

    public void keyPressed(int keyCode, int gameAction) {
        if (keyCode != 50 && keyCode != 52 && keyCode != 54 && keyCode != 56) {
            if (gameAction == 1 && keyCode != 114) {
                this.highlightButtonAbove();
            } else if (gameAction == 5 && keyCode != 103) {
                this.highlightRightButton();
            } else if (gameAction == 6 && keyCode != 118) {
                this.highlightButtonBelow();
            } else if (gameAction == 2 && keyCode != 100) {
                this.highlightLeftButton();
            }
        }
        this.calcCurrentRowsAndColumn();
    }

    public void setCalculatorCanvas(CalculatorCanvas calculatorCanvas) {
        this.calculatorCanvas = calculatorCanvas;
    }

    public CalculatorCanvas getCalculatorCanvas() {
        return this.calculatorCanvas;
    }

    public void setEditPanel(EditPanel editPanel) {
        this.editPanel = editPanel;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Button)this.buttons.elementAt(i)).setEditPanel(editPanel);
        }
    }

    public EditPanel getEditPanel() {
        return this.editPanel;
    }

    public Button getHighlightedButton() {
        return this.highlightedButton;
    }

    protected void addButton(int buttonType) {
        if (buttonType < 0 || buttonType > 28) {
            return;
        }
        int numberOfButtonsInCurrentRow = this.buttons.size() % this.columns;
        int numberOfFullRows = this.buttons.size() / this.columns;
        Button button = new Button(this.displaySize, buttonType);
        button.setButtonPanel(this);
        int xPosButton = numberOfButtonsInCurrentRow * button.getWidth() + (numberOfButtonsInCurrentRow + 1) * this.spacing;
        int yPosButton = numberOfFullRows * button.getHeight() + (numberOfFullRows + 1) * this.spacing;
        button.setXPos(this.xPos + xPosButton);
        button.setYPos(this.yPos + yPosButton);
        this.buttons.addElement(button);
        if (this.buttons.size() == 1) {
            button.setHighlighted(true);
            this.highlightedButton = button;
        }
        this.numberOfRows = this.buttons.size() / this.columns;
        if (this.buttons.size() % this.columns != 0) {
            ++this.numberOfRows;
        }
    }

    protected void highlightButtonAbove() {
        this.highlightedButton.setHighlighted(false);
        this.highlightedButtonIndex -= this.columns;
        if (this.highlightedButtonIndex < 0) {
            this.highlightedButtonIndex += this.numberOfRows * this.columns;
            if (this.highlightedButtonIndex > this.buttons.size() - 1) {
                this.highlightedButtonIndex = this.buttons.size() - 1;
            }
        }
        this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
        this.highlightedButton.setHighlighted(true);
    }

    protected void highlightRightButton() {
        this.highlightedButton.setHighlighted(false);
        this.highlightedButtonIndex = this.highlightedButtonIndex == this.buttons.size() - 1 ? 0 : ++this.highlightedButtonIndex;
        this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
        this.highlightedButton.setHighlighted(true);
    }

    protected void highlightButtonBelow() {
        this.highlightedButton.setHighlighted(false);
        this.highlightedButtonIndex += this.columns;
        if (this.highlightedButtonIndex > this.buttons.size() - 1) {
            this.highlightedButtonIndex -= this.numberOfRows * this.columns;
            if (this.highlightedButtonIndex < 0) {
                this.highlightedButtonIndex = this.buttons.size() - 1;
            }
        }
        this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
        this.highlightedButton.setHighlighted(true);
    }

    protected void highlightLeftButton() {
        this.highlightedButton.setHighlighted(false);
        this.highlightedButtonIndex = this.highlightedButtonIndex == 0 ? this.buttons.size() - 1 : --this.highlightedButtonIndex;
        this.highlightedButton = (Button)this.buttons.elementAt(this.highlightedButtonIndex);
        this.highlightedButton.setHighlighted(true);
    }

    protected void calcCurrentRowsAndColumn() {
        this.previousRowIndex = this.currentRowIndex;
        this.currentRowIndex = this.highlightedButtonIndex / this.columns;
        this.currentColumnIndex = this.highlightedButtonIndex % this.columns;
    }
}

